module net.BurtonRadons.spyl.valueBoolean;

private import net.BurtonRadons.spyl.value;

class BooleanValue : Value
{
    private static bit locked = true; /**< Attempting to create an instance while locked results in an exception. */
    bit content; /**< Actual value. */
    
    /** Do not call this; use create instead. */
    this (bit content)
    {
        if (locked)
            throw new Error ("BooleanValue cannot be instantiated.");
        this.content = content;
    }
    
    /** The actual constructor. */
    static BooleanValue create (bit content)
    {
        if (content)
            return True;
        return False;
    }
    
    char [] typeName ()
    {
        return "Boolean";
    }
    
    char [] repr ()
    {
        if (content)
            return "true";
        return "false";
    }
}

BooleanValue True;
BooleanValue False;

static this ()
{
    BooleanValue.locked = false;
    True = new BooleanValue (true);
    False = new BooleanValue (false);
    BooleanValue.locked = true;
}
